unit uEditor;
interface
uses Windows, Forms,Controls, Classes, ExtCtrls, ComCtrls, DAudioEffectX,
  StdCtrls, Graphics,gauges;

type
  TPluginEditorWindow = class(TForm)
    Updater: TTimer;
    bg: TImage;
    Label01: TLabel;
    Label03: TLabel;
    Label05: TLabel;
    Label06: TLabel;
    Vol: TGauge;
    FltType: TImage;
    FltType2: TImage;
    Label1: TLabel;
    Wet: TGauge;
    Bits: TGauge;
    Label02: TLabel;
    SHRate: TGauge;
    Cutoff: TGauge;
    Reso: TGauge;
    Panel1: TPanel;
    Image1: TImage;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Image2: TImage;
    Image3: TImage;
    procedure UpdaterTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FltTypeClick(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Image3Click(Sender: TObject);
  private
    FEffect:AudioEffectX;
    procedure SldMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SldMouseDown(Sender: TObject; Button:TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  public
    manually:boolean;
    fWet,fbits,fshrate,
    fCutoff,fResonance,fFType,fOutVol:single;
    property Effect: AudioEffectX read FEffect write FEffect;
  private
  end;

implementation

{$R *.DFM}

uses uPlugin;

procedure TPluginEditorWindow.UpdaterTimer(Sender: TObject);
begin
 manually:=true;
 Vol.progress:=round(fOutVol*vol.maxvalue);
 Wet.progress:=round(fWet*wet.maxvalue);
 Bits.progress:=round(fbits*bits.maxvalue);
 shrate.progress:=round(fshrate*shrate.maxvalue);
 Cutoff.progress:=round(fCutoff*cutoff.maxvalue);
 Reso.progress:=round(fResonance*reso.maxvalue);
 if fFType>0.5 then
  FltType.visible:=true
 else
  FltType.visible:=false;
 manually:=false;
end;

procedure TPluginEditorWindow.SldMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
 if (Shift=[ssLeft])and (not manually) then
 begin
  if y>(Sender as TGauge).height then y:=(Sender as TGauge).height;
  if y<0 then y:=0;
  (Sender as TGauge).progress:=(Sender as TGauge).height-y;
  case (Sender as TGauge).tag of
  kWet:begin
   fWet:=Wet.progress/wet.maxvalue;
   Effect.setParameterAutomated(kWet,fWet);
  end;
  kbits:begin
   fbits:=bits.progress/bits.maxvalue;
   Effect.setParameterAutomated(kbits,fbits);
  end;
  kOutVol:begin
   fOutVol:=Vol.progress/vol.maxvalue;
   Effect.setParameterAutomated(kOutVol,fOutVol);
  end;
  kshrate:begin
   fshrate:=shrate.progress/shrate.maxvalue;
   Effect.setParameterAutomated(kshrate,fshrate);
  end;
  kCutoff:begin
   fCutoff:=Cutoff.progress/cutoff.maxvalue;
   Effect.setParameterAutomated(kCutoff,fCutoff);
  end;
  kResonance:begin
   fResonance:=Reso.progress/reso.maxvalue;
   Effect.setParameterAutomated(kResonance,fResonance);
  end;
  else
  end;

 end;
end;

procedure TPluginEditorWindow.SldMouseDown(Sender: TObject;
  Button:TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 SldMouseMove(Sender,Shift,X,Y);
end;

procedure TPluginEditorWindow.FormCreate(Sender: TObject);
begin
 Vol.onmousemove:=sldmousemove;Vol.onmousedown:=sldmousedown;
 bits.onmousemove:=sldmousemove;bits.onmousedown:=sldmousedown;
 Wet.onmousemove:=sldmousemove;Wet.onmousedown:=sldmousedown;

 shrate.onmousemove:=sldmousemove;shrate.onmousedown:=sldmousedown;
 Cutoff.onmousemove:=sldmousemove;Cutoff.onmousedown:=sldmousedown;
 Reso.onmousemove:=sldmousemove;Reso.onmousedown:=sldmousedown;

 vol.maxvalue:=vol.height;
 bits.maxvalue:=bits.height;
 wet.maxvalue:=wet.height;
 shrate.maxvalue:=shrate.height;
 cutoff.maxvalue:=cutoff.height;
 reso.maxvalue:=reso.height;
 panel1.top:=64;
end;

procedure TPluginEditorWindow.FltTypeClick(Sender: TObject);
begin
 if FltType.visible then
 begin
  FltType.visible:=false;
  fFType:=0;
 end else
 begin
  FltType.visible:=true;
  fFType:=1;
 end;
 Effect.setParameterAutomated(kFType,fFType);
end;

procedure TPluginEditorWindow.Image1Click(Sender: TObject);
begin
 panel1.visible:=false;
end;

procedure TPluginEditorWindow.Image3Click(Sender: TObject);
begin
 panel1.visible:=not panel1.visible;
end;

end.



